FruitCollectLoadSettingsEvent = {};
FruitCollectLoadSettingsEvent_mt = Class(FruitCollectLoadSettingsEvent, Event);
InitEventClass(FruitCollectLoadSettingsEvent, "FruitCollectLoadSettingsEvent");

FruitCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function FruitCollectLoadSettingsEvent.emptyNew()
    local self = Event.new(FruitCollectLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function FruitCollectLoadSettingsEvent.new(minMax)
    local self = FruitCollectLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function FruitCollectLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then        
        self.minMax = streamReadInt8(streamId, FruitCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function FruitCollectLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["fruitCollectMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["fruitCollectMission_minMax"], FruitCollectLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function FruitCollectLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(FruitCollectLoadSettingsEvent.new(g_additionalContractTypes.settings["fruitCollectMission_minMax"]), false);				
		return;
	end;
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["fruitCollectMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


