MulcherLoadSettingsEvent = {};
MulcherLoadSettingsEvent_mt = Class(MulcherLoadSettingsEvent, Event);
InitEventClass(MulcherLoadSettingsEvent, "MulcherLoadSettingsEvent");

MulcherLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function MulcherLoadSettingsEvent.emptyNew()
    local self = Event.new(MulcherLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function MulcherLoadSettingsEvent.new(onOff, minMax)
    local self = MulcherLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function MulcherLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then
        self.minMax = streamReadInt8(streamId, MulcherLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function MulcherLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["mulcherMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["mulcherMission_minMax"], MulcherLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function MulcherLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(MulcherLoadSettingsEvent.new(g_additionalContractTypes.settings["mulcherMission_minMax"]), false);				
		return;
	end;   
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["mulcherMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


