AutoRepair = {};

AutoRepair.metadata = {
	interface = "FS25 ...", --convert LS22 to LS25
	title = "AutoRepair",
	notes = "Dieser Mod Repariert alle Fahrzeuge um ~00:00 und 12:00 Uhr. (Keine Missions Fahrzeuge)",
	author = "(by HappyLooser)",
	version = "1.0.0.1",
	build = 5,
	datum = " 28.12.2023",
	update = " 30.01.2025",
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

AutoRepair.minRepair = 0.5; --from 5%
AutoRepair.repairHours = {0,12,24}; --optional edit here, differenz min 1 also {0,2,4 .....}

function AutoRepair:loadMap(mapName)
	print("---loading ".. tostring(AutoRepair.metadata.title).. " ".. tostring(AutoRepair.metadata.version).. "(#".. tostring(AutoRepair.metadata.build).. ") ".. tostring(AutoRepair.metadata.author).. "---")	
	AutoRepair.canRepair = true;	
	if not AutoRepair:isMP() or AutoRepair:getDetiServer() or AutoRepair:getHostServer() then
		autorepair = {};
		function autorepair:onHourChanged()
			if AutoRepair.canRepair and AutoRepair:isRepairHours() then
				for _, vehicle in pairs(g_currentMission.vehicleSystem.vehicles) do
					if vehicle ~= nil and vehicle.finishedLoading == true and vehicle.getVehicleDamage ~= nil and vehicle.repairVehicle ~= nil then
						local missionsVehicle = vehicle.propertyState >= 4 or (vehicle.propertyState >= 2 and vehicle.activeMissionId ~= nil and vehicle.activeMissionId > 0);
						local isDamage = math.min(1, 1 - vehicle:getDamageAmount());
						if vehicle.ownerFarmId ~= 0 and not missionsVehicle and isDamage >= AutoRepair.minRepair then		
							vehicle:repairVehicle(true);
						end;
					end;
				end;		
				AutoRepair.canRepair = false;				
			end;	
			if not AutoRepair.canRepair and not AutoRepair:isRepairHours() then
				AutoRepair.canRepair = true;
			end;		
		end;
		FSBaseMission.onHourChanged = Utils.prependedFunction(FSBaseMission.onHourChanged, autorepair.onHourChanged);
	else	
		print("---".. tostring(AutoRepair.metadata.title).. " not loaded for MP Client---");
	end;
end;
addModEventListener(AutoRepair);

function AutoRepair:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function AutoRepair:getHostServer()		
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil and g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoRepair:isMP()		
	return g_currentMission.missionDynamicInfo.isMultiplayer;	
end;

function AutoRepair:isRepairHours()
	for h=1, #AutoRepair.repairHours do
		if AutoRepair.repairHours[h] == g_currentMission.environment.currentHour then return true;end;
	end;
	return false;
end;