--[[
ADD ALL FRUITS WITH CATEGORY="WINDROWS" TO TEDDER FUNCTION
by Sablerock
date written: 2025/01/01
]]

multiFruitTedder = {}

print("===multiFruitTedder loaded - Sablerock===")

function multiFruitTedderAI(self,savegame)
	local spec = {}
	
	spec.supportedFillTypes = g_fillTypeManager:getFillTypesByCategoryNames("WINDROW")
	
	for _, fillTypeIndex in ipairs(spec.supportedFillTypes) do
		
		local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
	
		local fillTypeName = g_fillTypeManager:getFillTypeNameByIndex(fillTypeIndex)
		local fillTypeConstant = FillType[fillType.name:upper()] -- Access the FillType global constant		
		self:addAIDensityHeightTypeRequirement(fillTypeConstant) 
		print(string.format("AI tedding added for: %s - %s", fillTypeIndex, fillTypeName))
	end
end

function multiFruitTedder:loadMap(name)
	Tedder.onLoad = Utils.appendedFunction(Tedder.onLoad, multiFruitTedderAI)
end

addModEventListener(multiFruitTedder)


